var contextMenuItem = {
  id: "Send_Address_To_Organizer",
  title: "Add to Do not Disturb List",
  contexts: ["selection"],
};


chrome.contextMenus.create(contextMenuItem);


chrome.contextMenus.onClicked.addListener(function (clickData) {
  if (
    clickData.menuItemId == "Send_Address_To_Organizer" &&
    clickData.selectionText
  ) {

    let loadingWindow = null;
    chrome.windows.create(
      {
        url: "wait.html",
        type: "popup",
        focused: true,
        width: 400,
        height: 200,
        top: 0,
        left: 400,
      },
      (window) => {
        loadingWindow = window.id;
      }
    );
    response = fetch(
      "https://lists.yellowletterhq.com/insert-address?selectedText=" +
        clickData.selectionText
    )
      .then((response) => response.text())
      .then((data) => {
        responseData = JSON.parse(data);
        if (responseData.response_value == 0) {
          chrome.windows.remove(loadingWindow);

          let loginWindow = null;
          chrome.windows.create(
            {
              url: "nologin.html",
              type: "popup",
              focused: true,
              width: 400,
              height: 200,
              top: 0,
              left: 400,
            },
            (window) => {
              loginWindow = window.id;
            }
          );
        } else if (responseData.response_value == 3) {
          chrome.notifications.clear("loadingNotification");
          chrome.windows.remove(loadingWindow);
          let subscriptionWindow = null;
          chrome.windows.create(
            {
              url: "subscription.html",
              type: "popup",
              focused: true,
              width: 400,
              height: 200,
              top: 0,
              left: 400,
            },
            (window) => {
              subscriptionWindow = window.id;
            }
          );
        }else if (responseData.response_value == 4) {
          chrome.windows.remove(loadingWindow);
          let errorWindow = null;
          chrome.windows.create(
            {
              url: "error.html",
              type: "popup",
              focused: true,
              width: 400,
              height: 200,
              top: 0,
              left: 400,
            },
            (window) => {
              errorWindow = window.id;
            }
          );
        } else {
          chrome.windows.remove(loadingWindow);
          popupWindowId = null;
          chrome.windows.create(
            {
              url: "popup.html",
              type: "popup",
              focused: true,
              width: 800,
              height: 400,
              top: 0,
              left: 400,
            },
            (window) => {
              popupWindowId = window.id;

            }
          );

          chrome.runtime.onMessage.addListener(function (
            request,
            sender,
            sendResponse
          ) {
            if (request.method == "getStatus") {
              sendResponse({ method: "test", data: responseData });
            }
          });
        }
      }).catch(error=>{
        connectionWindowId = null;
        chrome.windows.create(
          {
            url: "connection.html",
            type: "popup",
            focused: true,
            width: 400,
            height: 200,
            top: 0,
            left: 400,
          },
          (window) => {
            connectionWindowId = window.id;
          }
        );
    });
  }
});
