chrome.runtime.sendMessage(
  { method: "getStatus", data: "test" },
  function (res) {

    if (res.data.success == 0) {
      if (res.data.record_exists) {
        alert(
          "No Match found in the database and record already exist in the DNC list."
        );
        return;
      }

      if (
        confirm(
          "No Match Found and it does not exist in the DNC list. Do you want to add record to DNM?"
        )
      ) {
        var result = Object.entries(res.data);
        response = fetch(
          "https://lists.yellowletterhq.com//update-address-status?property_address=" +
            result[1][1]["property_address"] +
            "&property_city=" +
            result[1][1]["property_city"] +
            "&property_state=" +
            result[1][1]["property_state"] +
            "&property_zip=" +
            result[1][1]["property_zip"]
        )
          .then((response) => response.text())
          .then((data) => {
            responseData = JSON.parse(data);
            if (responseData.success) {
              document.getElementById("success").innerHTML =
                "Record Successfully added to do not mail List";
            }
          });
      }
      return;
    }
    document.getElementById("recordCount").innerHTML =
      Object.keys(res.data).length + " record(s) found in your database";

    const table = document.createElement("table");

    var header = table.createTHead();
    const headerRow = header.insertRow(0);
    var checkboxAll = document.createElement("input");
    checkboxAll.type = "checkbox";
    checkboxAll.id="checkAll";
    const headercheckBox = headerRow.insertCell(0);
    headercheckBox.addEventListener('change',function(event){
      var checkboxes = document.querySelectorAll(".propertyIds");
      checkboxes.forEach(function (checkbox) {
      if(event.target.checked){
        checkbox.checked=true;
      }
      else{
        checkbox.checked=false;

      }
      });
    });
    headercheckBox.appendChild(checkboxAll);

    const headerPropertyAddressCell = headerRow.insertCell(1);
    const headerPropertyCityCell = headerRow.insertCell(2);
    const headerPropertyStateCell = headerRow.insertCell(3);
    const headerPropertyZIPCell = headerRow.insertCell(4);
    const headerMailingAddressCell = headerRow.insertCell(5);
    const headerMailingCityCell = headerRow.insertCell(6);
    const headerMailingStateCell = headerRow.insertCell(7);
    const headerMailingZIPCell = headerRow.insertCell(8);

    headerPropertyAddressCell.textContent = "Property Address";
    headerPropertyCityCell.textContent = "Property City";
    headerPropertyStateCell.textContent = "Property State";
    headerPropertyZIPCell.textContent = "Property Zip";
    headerMailingAddressCell.textContent = "Mailing Address";
    headerMailingCityCell.textContent = "Mailing City";
    headerMailingStateCell.textContent = "Mailing State";
    headerMailingZIPCell.textContent = "Mailing Zip";

    propertyIds = Array();
    for (const key in res.data) {
      const row = table.insertRow();
      const checkBoxCell = row.insertCell(0);
      const cell1 = row.insertCell(1);
      const cell2 = row.insertCell(2);
      const cell3 = row.insertCell(3);
      const cell4 = row.insertCell(4);
      const cell5 = row.insertCell(5);
      const cell6 = row.insertCell(6);
      const cell7 = row.insertCell(7);
      const cell8 = row.insertCell(8);
      propertyIds.push(res.data[key].id);
      var checkbox = document.createElement("input");
      checkbox.type = "checkbox";
      checkbox.classList.add("propertyIds");
      checkbox.value = res.data[key].id;

      checkbox.addEventListener('change',function(event){
        var checkboxes = document.querySelectorAll(".propertyIds");
        const selectAllCheckbox=document.getElementById('checkAll');
        if (!event.target.checked) {
          selectAllCheckbox.checked = false;
        } else {
          allChecked = true;
          for (var i = 0; i < checkboxes.length; i++) {
            if (!checkboxes[i].checked) {
              allChecked = false;
            }
          }
          if (allChecked) {
            selectAllCheckbox.checked = true;
          }
        }
      });

      checkBoxCell.appendChild(checkbox);
      cell1.textContent = res.data[key].property_address;
      cell2.textContent = res.data[key].property_city;
      cell3.textContent = res.data[key].property_state;
      cell4.textContent = res.data[key].property_zip;
      cell5.textContent = res.data[key].mailing_address;
      cell6.textContent = res.data[key].mailing_city;
      cell7.textContent = res.data[key].mailing_state;
      cell8.textContent = res.data[key].mailing_zip;
    }
    const tableContainer = document.getElementById("data");
    tableContainer.appendChild(table);
    const addButton = document.createElement("button");
    addButton.textContent = "Add to do not mail List";
    addButton.classList.add("addButton");

    addButton.addEventListener("click", function () {
      var checkboxes = document.querySelectorAll(".propertyIds");
      var selectedCheckBoxValues = [];
      checkboxes.forEach(function (checkbox) {
        if (checkbox.checked) {
          selectedCheckBoxValues.push(checkbox.value);
        }
      });
      console.log(selectedCheckBoxValues);
      if (selectedCheckBoxValues.length) {
        addToList(selectedCheckBoxValues);
      } else {
        alert("no record selected");
      }
    });

    const addButtonContainer = document.getElementById("addButton");

    addButtonContainer.appendChild(addButton);
  }
);

function addToList(data) {
  if (confirm("Confirm you want it Flag as Do Not Mail.")) {
    response = fetch(
      "https://lists.yellowletterhq.com/update-address-status?propertyIds=" +
        data
    )
      .then((response) => response.text())
      .then((data) => {
        responseData = JSON.parse(data);
        if (responseData.success) {
          document.getElementById("success").innerHTML =
            "Record(s) Successfully added to do not mail List";
        }
      });
  }
}
